unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons, Registry;

type
  TForm2 = class(TForm)
    Label1: TLabel;
    ColorBox1: TColorBox;
    Label2: TLabel;
    ColorBox2: TColorBox;
    Label3: TLabel;
    Panel1: TPanel;
    Memo1: TMemo;
    Button1: TButton;
    CheckBox1: TCheckBox;
    FontDialog1: TFontDialog;
    Panel2: TPanel;
    Button2: TButton;
    Label4: TLabel;
    procedure Button2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ColorBox2Change(Sender: TObject);
    procedure ColorBox1Change(Sender: TObject);
  private
    { Private declarations }
    rozmiarCzcionki :Integer;
  public
    { Public declarations }
  end;

procedure ZapiszDoRejestru(kolorTla :TColor;czcionka: TFont;ignorujRuchMyszki :Boolean);
procedure CzytajZRejestru(var kolorTla :TColor;var czcionka: TFont;var ignorujRuchMyszki :Boolean);

const WielkoscCzcionkiPodgladu=7;

var
  Form2: TForm2;

implementation

{$R *.dfm}

procedure TForm2.ColorBox1Change(Sender: TObject);
begin
Memo1.Color:=ColorBox1.Selected;
end;

procedure TForm2.ColorBox2Change(Sender: TObject);
begin
Memo1.Font.Color:=ColorBox2.Selected;
end;

procedure TForm2.Button1Click(Sender: TObject);
begin
FontDialog1.Font:=Memo1.Font;
FontDialog1.Font.Size:=rozmiarCzcionki;
if FontDialog1.Execute then
  begin
  Memo1.Font:=FontDialog1.Font;
  rozmiarCzcionki:=FontDialog1.Font.Size;
  Memo1.Font.Size:=WielkoscCzcionkiPodgladu;
  ColorBox2.Selected:=FontDialog1.Font.Color;
  end;
end;

procedure ZapiszDoRejestru(kolorTla :TColor;czcionka: TFont;ignorujRuchMyszki :Boolean);
const klucz='\SOFTWARE\JM\WM_ScreenSaver';
var Rejestr :TRegistry;
begin
Rejestr:=TRegistry.Create;
Rejestr.Access:=KEY_WRITE;
Rejestr.RootKey:=HKEY_CURRENT_USER;

if Rejestr.OpenKey(klucz,True) then
  begin
  Rejestr.WriteString('Font.Name',czcionka.Name);
  Rejestr.WriteInteger('Font.Size',czcionka.Size);
  Rejestr.WriteInteger('Font.Color',czcionka.Color);
  Rejestr.WriteBool('Font.Bold',fsBold in czcionka.Style);
  Rejestr.WriteBool('Font.Italic',fsItalic in czcionka.Style);
  Rejestr.WriteBool('Font.Underline',fsUnderline in czcionka.Style);
  Rejestr.WriteBool('Font.StrikeOut',fsStrikeOut in czcionka.Style);
  Rejestr.WriteInteger('Background',kolorTla);
  Rejestr.WriteBool('IgnoreMouseMovement',ignorujRuchMyszki);
  Rejestr.CloseKey;
  end
  else ShowMessage('Klucz "'+klucz+'" nie moe by otwarty.');

Rejestr.Free;
end;

procedure CzytajZRejestru(var kolorTla :TColor;var czcionka: TFont;var ignorujRuchMyszki :Boolean);
const klucz='\SOFTWARE\JM\WM_ScreenSaver';
var
  Rejestr :TRegistry;
  StylCzcionki :TFontStyles;
begin
Rejestr:=TRegistry.Create;
Rejestr.Access:=KEY_READ;
Rejestr.RootKey:=HKEY_CURRENT_USER;

if Rejestr.OpenKey(klucz,False) then
  begin
  czcionka.Name:=Rejestr.ReadString('Font.Name');
  czcionka.Size:=Rejestr.ReadInteger('Font.Size');
  czcionka.Color:=Rejestr.ReadInteger('Font.Color');

  StylCzcionki:=czcionka.Style;
  if Rejestr.ReadBool('Font.Bold') then Include(StylCzcionki,fsBold) else Exclude(StylCzcionki,fsBold);
  if Rejestr.ReadBool('Font.Italic') then Include(StylCzcionki,fsItalic) else Exclude(StylCzcionki,fsItalic);
  if Rejestr.ReadBool('Font.Underline') then Include(StylCzcionki,fsUnderline) else Exclude(StylCzcionki,fsUnderline);
  if Rejestr.ReadBool('Font.StrikeOut') then Include(StylCzcionki,fsStrikeOut) else Exclude(StylCzcionki,fsStrikeOut);
  czcionka.Style:=StylCzcionki;

  kolorTla:=Rejestr.ReadInteger('Background');
  ignorujRuchMyszki:=Rejestr.ReadBool('IgnoreMouseMovement');
  Rejestr.CloseKey;
  end
  else
  begin
  //ustalanie domylnych
  czcionka.Name:='Courier New';
  czcionka.Size:=10;
  czcionka.Color:=clGray;
  kolorTla:=clBlack;
  ignorujRuchMyszki:=False;
  end;

Rejestr.Free;
end;


procedure TForm2.FormCreate(Sender: TObject);
var
  czcionka :TFont;
  kolorTla :TColor;
  ignorujRuchMyszki :Boolean;
begin
czcionka:=TFont.Create;
CzytajZRejestru(kolorTla,czcionka,ignorujRuchMyszki);
rozmiarCzcionki:=czcionka.Size;
czcionka.Size:=WielkoscCzcionkiPodgladu;
Memo1.Font.Assign(czcionka);
ColorBox1.Selected:=kolorTla;
ColorBox2.Selected:=czcionka.Color;
CheckBox1.Checked:=ignorujRuchMyszki;

ColorBox1Change(nil);
ColorBox2Change(nil);
end;

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
var
  czcionka :TFont;
begin
czcionka:=TFont.Create;
czcionka.Assign(Memo1.Font);
czcionka.Size:=rozmiarCzcionki;
ZapiszDoRejestru(ColorBox1.Selected,czcionka,CheckBox1.Checked);
end;

procedure TForm2.Button2Click(Sender: TObject);
begin
Close;
end;

end.
